/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/*    Copyright (C) 2002-2022 Konrad-Zuse-Zentrum                            */
/*                            fuer Informationstechnik Berlin                */
/*                                                                           */
/*  SCIP is distributed under the terms of the ZIB Academic License.         */
/*                                                                           */
/*  You should have received a copy of the ZIB Academic License              */
/*  along with SCIP; see the file COPYING. If not visit scip.zib.de.         */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file   enumeration.h
 * @brief  includes enumeration algorithms for Steiner tree problems
 * @author Daniel Rehfeldt
 *
 *
 */

/*---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/



#ifndef APPLICATIONS_STP_SRC_ENUMERATION_H_
#define APPLICATIONS_STP_SRC_ENUMERATION_H_

#include "graph.h"
#include "scip/scip.h"


#ifdef __cplusplus
extern "C" {
#endif


extern SCIP_RETCODE enumeration_findSolPcMw(SCIP*, GRAPH*, int* RESTRICT);
extern SCIP_Bool enumeration_isPossible(const GRAPH*);



#ifdef __cplusplus
}
#endif

#endif /* APPLICATIONS_STP_SRC_ENUMERATION_H_ */
