/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                           */
/*                  This file is part of the program and library             */
/*         SCIP --- Solving Constraint Integer Programs                      */
/*                                                                           */
/*    Copyright (C) 2002-2022 Konrad-Zuse-Zentrum                            */
/*                            fuer Informationstechnik Berlin                */
/*                                                                           */
/*  SCIP is distributed under the terms of the ZIB Academic License.         */
/*                                                                           */
/*  You should have received a copy of the ZIB Academic License              */
/*  along with SCIP; see the file COPYING. If not visit scipopt.org.         */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/**@file   scipcoreplugins.c
 * @ingroup OTHER_CFILES
 * @brief  register additional core functionality designed as plugins
 * @author Gregor Hendel
 */

/*--+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2*/

#include "scip/scipcoreplugins.h"

/** includes core SCIP plugins into SCIP */
SCIP_RETCODE SCIPincludeCorePlugins(
   SCIP*                 scip                /**< SCIP data structure */
   )
{
   SCIP_CALL( SCIPincludeBanditvtableEpsgreedy(scip) );
   SCIP_CALL( SCIPincludeBanditvtableExp3(scip) );
   SCIP_CALL( SCIPincludeBanditvtableUcb(scip) );

   return SCIP_OKAY;
}
